class Cube extends WireFrame {
    // der Konstruktor legt einen Würfel zentriert um den Urpsrung
    // und mit Seitenlänge 1 an; die Würfelkanten sind parallel zu
    // den Koordinatenachsen
    Cube(final color c) {
        super();

        // Punkte hinzufügen
        addVertex(new Point3D(-0.5, -0.5,  0.5)); // 0
        addVertex(new Point3D( 0.5, -0.5,  0.5)); // 1
        addVertex(new Point3D( 0.5,  0.5,  0.5)); // 2
        addVertex(new Point3D(-0.5,  0.5,  0.5)); // 3
        addVertex(new Point3D(-0.5, -0.5, -0.5)); // 4
        addVertex(new Point3D( 0.5, -0.5, -0.5)); // 5
        addVertex(new Point3D( 0.5,  0.5, -0.5)); // 6
        addVertex(new Point3D(-0.5,  0.5, -0.5)); // 7

        // Punkte für das lokale Koordinatensystem
        //addVertex(new Point3D(0.0, 0.0, 0.0)); //  8
        //addVertex(new Point3D(1.0, 0.0, 0.0)); //  9
        //addVertex(new Point3D(0.0, 1.0, 0.0)); // 10
        //addVertex(new Point3D(0.0, 0.0, 1.0)); // 11

        // Linien hinzufügen
        // Vorderseite
        addLine(0, 1, c);
        addLine(1, 2, c);
        addLine(2, 3, c);
        addLine(3, 0, c);
        // Rückseite
        addLine(4, 5, c);
        addLine(5, 6, c);
        addLine(6, 7, c);
        addLine(7, 4, c);
        // Linien der Seitenflächen
        addLine(0, 4, c);
        addLine(1, 5, c);
        addLine(2, 6, c);
        addLine(3, 7, c);

        // lokales Koordinatensystem
        //addLine(8,  9, color(255, 0, 0));
        //addLine(8, 10, color(100, 255, 0));
        //addLine(8, 11, color(0, 0, 255));
    }
}

class Sphere extends WireFrame {
    private final int N = 20;

    // der Konstruktor legt eine Kugel mit Mittelpunkt im Ursprung
    // und Radius 1 an
    Sphere(final color c) {
        super();

        // Punkte hinzufügen
        // Südpol
        addVertex(new Point3D(0.0, -1.0, 0.0));
        // alle Punkte zwischen Süd- und Nordpol
        for (int i = 1; i < N/2; ++i) {
        // "geographische" Breite; wir beginnen beim Südpol
            float theta = PI - i*(PI/(N/2)); 
            for (int j = 0; j < N; ++j) {
                // "geographische" Länge
                float phi = j*(TAU/N);
                addVertex(new Point3D(sin(theta)*sin(phi),
                                      cos(theta),
                                      sin(theta)*cos(phi)));
            }
        }
        // Nordpol
        addVertex(new Point3D(0.0, 1.0, 0.0));

        // Linien hinzufügen
        int jp1; // j + 1
        // Dreiecke um den Südpol
        for (int j = 1; j <= N; ++j) {
            if (j < N) {
                jp1 = j + 1;
            }
            else {
                jp1 = 1;
            }
            addLine(0, j, c);
            addLine(j, jp1, c);
        }
        // Quadrate um Breiten-/Längenkreise zu zeichnen
        for (int i = 0; i < N/2 - 2; ++i) {
            for (int j = 1; j <= N; ++j) {
                if (j < N) {
                    jp1 = j + 1;
                }
                else {
                    jp1 = 1;
                }
                addLine(j + i*N, j + (i + 1)*N, c);
                addLine(j + (i + 1)*N, jp1 + (i + 1)*N, c);
            }
        }
        // Dreiecke um den Nordpol
        for (int j = 1; j <= N; ++j) {
            addLine(vertices.size() - N - 2 + j, vertices.size() - 1, c);
        }

        //final int numVertices = vertices.size();

        // Punkte für das lokale Koordinatensystem
        //addVertex(new Point3D(0.0, 0.0, 0.0)); // numVertices 
        //addVertex(new Point3D(1.5, 0.0, 0.0)); // numVertices + 1
        //addVertex(new Point3D(0.0, 1.5, 0.0)); // numVertices + 2
        //addVertex(new Point3D(0.0, 0.0, 1.5)); // numVertices + 3

        // lokales Koordinatensystem
        //addLine(numVertices,  numVertices + 1, color(255, 0, 0));
        //addLine(numVertices,  numVertices + 2, color(100, 255, 0));
        //addLine(numVertices,  numVertices + 3, color(0, 0, 255));
    }
}

class Plane extends WireFrame {
    final color c = color(150, 200, 255);
  
    Plane(final int Nx, final int Nz) {
        super();
    
        for (int i = -Nx; i <= Nx; ++i) {
            addVertex(new Point3D(i, 0.0, -Nz));
        }

        for (int i = -Nx; i <= Nx; ++i) {
            addVertex(new Point3D(i, 0.0, Nz));
        }

        for (int j = -Nz + 1; j <= Nz - 1; ++j) {
            addVertex(new Point3D(-Nx, 0.0, j));
        }

        for (int j = -Nz + 1; j <= Nz - 1; ++j) {
            addVertex(new Point3D(Nx, 0.0, j));
        }

        for (int i = 0; i <= 2*Nx; ++i) {
                addLine(i, 2*Nx + 1 + i, c);
        }

        addLine(0, 2*Nx, c);
        addLine(2*Nx + 1, 4*Nx + 1, c);

        for (int j = 1; j < 2*Nz; ++j) {
            addLine(4*Nx + j + 1, 4*Nx + 2*Nz + j, c);
        }

    }
}

// theCam ist eine quadratische Pyramide, um die Kamera zu zeigen
class theCam extends WireFrame {
    theCam() {
        // Punkte
        addVertex(new Point3D( 0.0,  0.0,  0.0)); // 0
        addVertex(new Point3D( 1.0,  1.0, -1.0)); // 1
        addVertex(new Point3D(-1.0,  1.0, -1.0)); // 2
        addVertex(new Point3D(-1.0, -1.0, -1.0)); // 3
        addVertex(new Point3D( 1.0, -1.0, -1.0)); // 4

        // Punkte für das lokale Koordinatensystem
        addVertex(new Point3D(0.0, 0.0, 0.0)); // 5
        addVertex(new Point3D(1.0, 0.0, 0.0)); // 6
        addVertex(new Point3D(0.0, 1.0, 0.0)); // 7
        addVertex(new Point3D(0.0, 0.0, 1.0)); // 8

        // Linien
        addLine(1, 2, color(255, 255, 255));
        addLine(2, 3, color(255, 255, 255)); 
        addLine(3, 4, color(255, 255, 255));
        addLine(4, 1, color(255, 255, 255));
        addLine(0, 1, color(255, 255, 255));
        addLine(0, 2, color(255, 255, 255));
        addLine(0, 3, color(255, 255, 255));
        addLine(0, 4, color(255, 255, 255));

        //addLine(1, 3, color(255, 0, 0));
        //addLine(2, 4, color(255, 0, 0));

        // lokales Koordinatensystem
        //addLine(5, 6, color(255, 0, 0)); //  right0
        //addLine(5, 7, color(0, 255, 0)); //  up0
        //addLine(5, 8, color(0, 0, 255)); // -fwd0
    }
}
