class Vec3D {
    // die Komponenten des Vektors
    final float x;
    final float y;
    final float z;

    // der Konstruktor speichert die Komponenten einfach ab 
    Vec3D(final float x, final float y, final float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    // berechnet das Kreuzprodukt dieses Vektors mit dem Vektor v
    Vec3D cross(final Vec3D v) {
        return new Vec3D(y*v.z - z*v.y,
                         z*v.x - x*v.z,
                         x*v.y - y*v.x);
    }
}

// berechnet die Länge des Vektors v
float Vec3D_norm(Vec3D v) {
    return sqrt(v.x*v.x + v.y*v.y + v.z*v.z);
}

// berechnet den Einheitsvektor v_0 zum Vektor v
Vec3D Vec3D_normalize(Vec3D v) {
    float m = 1.0/Vec3D_norm(v);

    return new Vec3D(m*v.x, m*v.y, m*v.z);
}
