class Point3D {
    // die Koordinaten des Punktes
    final float x;
    final float y;
    final float z;
    
    // weil die w-Koordinate der Punkte vorerst immer 1 ist,
    // speichern wir sie gar nicht erst ab
    // final float w = 1.0;

    // der Konstruktor speichert die Koordinaten einfach ab
    Point3D(final float x, final float y, final float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    // berechnet den Differenzvektor vom Punkt p
    // zu diesem Punkt ("Spitze-minus-Schaft")
    Vec3D minus(final Point3D p) {
        return new Vec3D(x - p.x, y - p.y, z - p.z);
    }

    // berechnet das Skalarprodukt des Ortsvektors zum Punkt
    // mit dem Vektor v
    float dot(final Vec3D v) {
        return x * v.x + y * v.y + z * v.z;
    }
}

// berechnet den Abstand eines Punkts zum Ursprung
float Point3D_norm(Point3D p) {
    return sqrt(p.x*p.x + p.y*p.y + p.z*p.z);
}
