class Camera {
    // speichert die view matrix
    Transform3D viewTransform; 
    Transform3D projectionTransform;

    // der Konstruktor legt die Einheitsmatrix als
    // view transformation fest
    Camera() {
        viewTransform = new Transform3D();
        projectionTransform = new Transform3D();
    }

    // setzt die view matrix der Kamera
    // auf die Einheitsmatrix zurück
    void resetTrafo() {  
        viewTransform.reset();
    }

    // berechnet die view matrix aus Augpunkt eye,
    // Zielpunkt lookAt und dem Vektor up, der in etwa
    // nach oben zeigt
    void setEyeAndLookAt(final Point3D eye, final Point3D lookAt, final Vec3D up) {
        Vec3D fwd0 = Vec3D_normalize(lookAt.minus(eye));
        Vec3D right0 = Vec3D_normalize(fwd0.cross(up));
        Vec3D up0 = right0.cross(fwd0);

        viewTransform.set(right0.x, right0.y, right0.z, -eye.dot(right0),
                             up0.x,    up0.y,    up0.z, -eye.dot(up0),
                           -fwd0.x,  -fwd0.y,  -fwd0.z,  eye.dot(fwd0),
                               0.0,      0.0,      0.0,  1.0);
    }

    // Setzt die Bildschirmbreite auf +/-w/2,
    // die Bildschirmhöhe auf +/-h/2 und
    // die z-Koordinate des Bildschirms auf -n
    void frustum(final float w, final float h, final float n) {
        projectionTransform.set(2.0/w,   0.0,   0.0, 0.0,
                                  0.0, 2.0/h,   0.0, 0.0,
                                  0.0,   0.0, 1.0/n, 0.0,
                                  0.0,   0.0,   0.0, 1.0);
    }
}
