// Die Längeneinheit für dieses Programm ist 1 m

Scene theScene;
Camera theCamera;
Rasterizer theRasterizer;

Cube[] cubes = new Cube[5*(2*20 + 1)];
Sphere s1;
Sphere[] spheres = new Sphere[4*5];
Plane p1;

void setup() {
    // öffne ein Zeichenfenster mit 720x480 Pixeln
    size(720, 480);
    //size(900, 600);
    //size(1620, 1080);

    theScene = new Scene();

    // alle Modelle werden angelegt und der Szene hinzugefügt

    p1 = new Plane(50, 50);
    theScene.addWireFrame(p1);

    for (int i = 0; i < 5*(2*20 + 1); ++i) {
        cubes[i] = new Cube(color(255, 0, 0));
        theScene.addWireFrame(cubes[i]);
    }

    for (int i = 0; i < 4*5; ++i) {
        spheres[i] = new Sphere(color(0, 200, 0));
        theScene.addWireFrame(spheres[i]);
    }      

    s1 = new Sphere(color(255, 176, 0));
    theScene.addWireFrame(s1);

    // wir haben eine bestimmte Kamera,
    // die wir dem Rasterizer bekannt machen
    theCamera = new Camera();
    theRasterizer = new Rasterizer(theScene, theCamera);

    strokeWeight(2);
    textSize(20);
    textAlign(LEFT, TOP);
}

float T = 20.0; // Periodendauer in s
float omega = TAU/T; // Kreisfrequenz in s^{-1}
float alpha;

void draw() {
    // wir füllen das Fenster schwarz
    background(0);

    int t = millis(); // Zeit seit Beginn der Animation in ms
    alpha = omega*t*1.0e-3; // *1.0e-3 Umrechnung ms -> s

    // "Brennweite" der Kamera
    float n = (0.135 + 0.024)/2.0 + (0.135 - 0.024)*cos(alpha)/2.0;
    // Abstand von der Kamera zum Kugelmittelpunkt
    float d = 3.0;
    
    // Kamera ausrichten und positionieren
    theCamera.setEyeAndLookAt(new Point3D(0.0, 1.0, d),
                              new Point3D(0.0, 1.0, 0.0),
                              new Vec3D(0.0, 1.0, 0.0));

    // Full frame sensor: 36 mm x 24 mm
    theCamera.frustum(0.036, 0.024, n);

    // die Objekte werden in jedem Frame neu transformiert

    p1.resetTrafo();
    p1.rotateY(TAU/16.0);

    for (int i = 0; i < 2*20 + 1; ++i) {
        for (int j = 0; j < 5; ++j) {
            cubes[(2*20 + 1)*j + i].resetTrafo();
            cubes[(2*20 + 1)*j + i].scale(0.25);
            //cubes[(2*20 + 1)*j + i].translate(-10.0 + i/2.0, (j + 0.25)/2.0, -5.0);
            cubes[(2*20 + 1)*j + i].translate(0.0, (j + 0.25)/2.0, -5.0);
            cubes[(2*20 + 1)*j + i].rotateY(TAU/4.0 - TAU/2.0/20.0*i);
        }
    }

    for (int i = 0; i < 5; ++i) {
        spheres[4*i].resetTrafo();
        spheres[4*i].scale(0.025);
        spheres[4*i].translate(-0.2, 1.2, -2.0 + 0.5*i);

        spheres[4*i + 1].resetTrafo();
        spheres[4*i + 1].scale(0.025);
        spheres[4*i + 1].translate(0.2, 1.2, -2.0 + 0.5*i);

        spheres[4*i + 2].resetTrafo();
        spheres[4*i + 2].scale(0.025);
        spheres[4*i + 2].translate(0.2, 0.8, -2.0 + 0.5*i);

        spheres[4*i + 3].resetTrafo();
        spheres[4*i + 3].scale(0.025);
        spheres[4*i + 3].translate(-0.2, 0.8, -2.0 + 0.5*i);
    }

    s1.resetTrafo();
    s1.scale(0.1);
    s1.translate(0.0, 1.0, 0.0);

    // der Rasterizer erhält zuerst die zu malenden
    // Linien der Szene und malt sie dann
    theRasterizer.stageLines();
    theRasterizer.paintScene(); //<>//

    String strd = nf(d, 1, 2).replace(',', '.');

    text(" n = " + nf(n*1.0e3, 3, -1) + " mm, d = " + strd + " m", 0, 0);
}
