class Transform3D {

    // affine Transformationsmatrix;
    // wir starten mit der Einheitsmatrix
    private float[][] M = {{1.0, 0.0, 0.0, 0.0},
                           {0.0, 1.0, 0.0, 0.0},
                           {0.0, 0.0, 1.0, 0.0},
                           {0.0, 0.0, 0.0, 1.0}};

    // mit dem Standardkonstruktor bleibt es bei
    // der Einheitsmatrix
    Transform3D() {}
    
    // dieser Konstruktor startet mit einer
    // beliebigen Matrix als Array
    Transform3D(float[][] m) {
        M = m;
    }
    
    // dieser Konstruktor startet mit einer
    // beliebigen Matrix als einzelne Elemente
    Transform3D(final float m00, final float m01, final float m02, final float m03,
                final float m10, final float m11, final float m12, final float m13,
                final float m20, final float m21, final float m22, final float m23,
                final float m30, final float m31, final float m32, final float m33) {
        M[0][0] = m00; M[0][1] = m01; M[0][2] = m02; M[0][3] = m03;
        M[1][0] = m10; M[1][1] = m11; M[1][2] = m12; M[1][3] = m13;
        M[2][0] = m20; M[2][1] = m21; M[2][2] = m22; M[2][3] = m23;
        M[3][0] = m30; M[3][1] = m31; M[3][2] = m32; M[3][3] = m33;
    }

    // die Matrixelemente lassen sich auch nachträglich setzen
    void set(final float m00, final float m01, final float m02, final float m03,
             final float m10, final float m11, final float m12, final float m13,
             final float m20, final float m21, final float m22, final float m23,
             final float m30, final float m31, final float m32, final float m33) {
        M[0][0] = m00; M[0][1] = m01; M[0][2] = m02; M[0][3] = m03;
        M[1][0] = m10; M[1][1] = m11; M[1][2] = m12; M[1][3] = m13;
        M[2][0] = m20; M[2][1] = m21; M[2][2] = m22; M[2][3] = m23;
        M[3][0] = m30; M[3][1] = m31; M[3][2] = m32; M[3][3] = m33;
    }
    
    // setzt die Transformation auf die Einheitsmatrix zurück
    void reset() {
        M[0][0] = 1.0; M[0][1] = 0.0; M[0][2] = 0.0; M[0][3] = 0.0;
        M[1][0] = 0.0; M[1][1] = 1.0; M[1][2] = 0.0; M[1][3] = 0.0;
        M[2][0] = 0.0; M[2][1] = 0.0; M[2][2] = 1.0; M[2][3] = 0.0;
        M[3][0] = 0.0; M[3][1] = 0.0; M[3][2] = 0.0; M[3][3] = 1.0;
    }

    // ersetzt die gespeicherte Matrix M durch B*M
    private void mul(final float[][] B) {
        // weil wir die Elemente von M für die Multiplikation
        // benötigen, müssen wir das Produkt zuerst in C
        // speichern
        float[][] C = new float[4][4]; // Java initialisiert Arrays mit 0

        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                for (int k = 0; k <= 3; ++k) {
                    C[i][j] += B[i][k]*M[k][j];
                }
            }
        }

        // jetzt können wir das Produkt nach M kopieren
        M = C;
    }

    // multipliziert die aktuelle Transformation mit
    // einer Skalierung in x-, y- und z-Richtung
    void scale(final float Sx, final float Sy, final float Sz) {
        final float[][] B = {{ Sx, 0.0, 0.0, 0.0},
                             {0.0,  Sy, 0.0, 0.0},
                             {0.0, 0.0,  Sz, 0.0},
                             {0.0, 0.0, 0.0, 1.0}};
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Translation in x-, y- und z-Richtung
    void translate(final float dX, final float dY, final float dZ) { 
        final float[][] B = {{1.0, 0.0, 0.0,  dX},
                             {0.0, 1.0, 0.0,  dY},
                             {0.0, 0.0, 1.0,  dZ},
                             {0.0, 0.0, 0.0, 1.0}};
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Rotation um die x-Achse
    void rotateX(final float angle) {
        final float[][] B = {{1.0,        0.0,         0.0, 0.0},
                             {0.0, cos(angle), -sin(angle), 0.0},
                             {0.0, sin(angle),  cos(angle), 0.0},
                             {0.0,        0.0,         0.0, 1.0}};
        
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Rotation um die y-Achse
    void rotateY(final float angle) {
        final float[][] B = {{ cos(angle), 0.0, sin(angle), 0.0},
                             {        0.0, 1.0,        0.0, 0.0},
                             {-sin(angle), 0.0, cos(angle), 0.0},
                             {        0.0, 0.0,        0.0, 1.0}};
        
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Rotation um die z-Achse
    void rotateZ(final float angle) {
        final float[][] B = {{cos(angle), -sin(angle), 0.0, 0.0},
                             {sin(angle),  cos(angle), 0.0, 0.0},
                             {       0.0,         0.0, 1.0, 0.0},
                             {       0.0,         0.0, 0.0, 1.0}};
        
        mul(B);
    }

    // wendet die aktuelle Transformation auf
    // einen Punkt an;
    // weil die w-Koordinate der Punkte vorerst immer
    // 1 ist, können wir sie ignorieren 
    Point3D apply(final Point3D p) {
        return new Point3D(M[0][0]*p.x + M[0][1]*p.y + M[0][2]*p.z + M[0][3],
                           M[1][0]*p.x + M[1][1]*p.y + M[1][2]*p.z + M[1][3],
                           M[2][0]*p.x + M[2][1]*p.y + M[2][2]*p.z + M[2][3]);
    }
}

// berechnet das Produkt der Transformationsmatrizen A und B
Transform3D Transform3D_mulAB(Transform3D A, Transform3D B) {
    float[][] C = new float[4][4]; // Java initialisiert Arrays mit 0

     for (int i = 0; i <= 3; ++i) {
         for (int j = 0; j <= 3; ++j) {
             for (int k = 0; k <= 3; ++k) {
                 C[i][j] += A.M[i][k] * B.M[k][j];
            }
        }
    }
    
    return new Transform3D(C);
}

// berechnet das Produkt der Transformationsmatrizen A, B und C
Transform3D Transform3D_mulABC(Transform3D A, Transform3D B, Transform3D C) {
    // B*C zuerst multiplizieren
    float[][] BC = new float[4][4]; // Java initialisiert Arrays mit 0

    for (int i = 0; i < 4; ++i) {
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 4; ++k) {
                BC[i][j] += B.M[i][k] * C.M[k][j];
            }
        }
    }

    // danach A*BC multiplizieren 
    float[][] ABC = new float[4][4]; // Java initialisiert Arrays mit 0

    for (int i = 0; i < 4; ++i) {
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 4; ++k) {
                ABC[i][j] += A.M[i][k] * BC[k][j];
            }
        }
    }
    
    return new Transform3D(ABC[0][0], ABC[0][1], ABC[0][2], ABC[0][3],
                           ABC[1][0], ABC[1][1], ABC[1][2], ABC[1][3],
                           ABC[2][0], ABC[2][1], ABC[2][2], ABC[2][3],
                           ABC[3][0], ABC[3][1], ABC[3][2], ABC[3][3]);
}
