Scene theScene;
Camera theCamera;
Rasterizer theRasterizer;

Cube c1;
Cube c2;
Cube c3;
Sphere s1;
theCam tc;

void setup() {
    // öffne ein Zeichenfenster mit 640x640 Pixeln
    size(640, 640);

    theScene = new Scene();

    // alle Modelle werden angelegt und der Szene hinzugefügt

    c1 = new Cube();
    theScene.addWireFrame(c1);

    c2 = new Cube();
    theScene.addWireFrame(c2);

    c3 = new Cube();
    theScene.addWireFrame(c3);

    s1 = new Sphere();
    theScene.addWireFrame(s1);

    // tc zeichnet die Pyramide einer Kamera
    tc = new theCam();
    theScene.addWireFrame(tc);

    // wir haben eine bestimmte Kamera,
    // die wir dem Rasterizer bekannt machen
    theCamera = new Camera();
    theRasterizer = new Rasterizer(theScene, theCamera);
}

float T = 5.0; // Periodendauer in s
float omega = TAU/T; // Winkelgeschwindigkeit n s^{-1}
float alpha;

void draw() {
    // wir füllen das Fenster schwarz
    background(0);

    int t = millis(); // Zeit seit Beginn der Animation in ms
    alpha = omega*t*1.0e-3; // *1.0e-3 Umrechnung ms -> s
    //alpha = 5.0;

    // Kamera ausrichten und positionieren
    theCamera.setEyeAndLookAt(new Point3D(0.0, 1.5, 1.5),
                              new Point3D(0.0, 0.0, -1.5),
                              new Vec3D(0.0, 1.0, 0.0));

    // die Objekte werden in jedem Frame neu transformiert

    // um die Kamera zeigen zu können, müssen wir die Transformation
    // händisch nachstellen

    float r = 2.0;
    float eye_y = -1.0;

    Point3D eye = new Point3D(r*sin(alpha), eye_y, -1.5 + r*cos(alpha));
    Point3D lookAt = new Point3D(0.0, 0.0, -1.5);
    Vec3D up = new Vec3D(0.0, 1.0, 0.0);
    //Point3D eye = new Point3D(r*cos(alpha), r*sin(alpha), -2.5);
    //Point3D lookAt = new Point3D(0.0, 0.0, -1.5);
    //Vec3D up = new Vec3D(-sin(alpha), cos(alpha), 0.0);
    
    Vec3D fwd0 = Vec3D_normalize(lookAt.minus(eye));
    Vec3D right0 = Vec3D_normalize(fwd0.cross(up));
    Vec3D up0 = right0.cross(fwd0);

    Transform3D camTransform = new Transform3D(right0.x, up0.x, -fwd0.x, eye.x,
                                               right0.y, up0.y, -fwd0.y, eye.y,
                                               right0.z, up0.z, -fwd0.z, eye.z,
                                                    0.0,   0.0,     0.0,   1.0);

    tc.resetTrafo();
    tc.mulTransform(camTransform);

    c1.resetTrafo();
    c1.scale(0.25, 0.375, 0.5);
    c1.translate(0.0, -0.75, -1.5);

    c2.resetTrafo();
    c2.scale(0.25);
    c2.translate(-0.75, 0.75, -1.5);

    c3.resetTrafo();
    c3.scale(0.25);
    c3.translate(0.75, 0.75, -1.5);

    s1.resetTrafo();
    s1.scale(0.35);
    s1.translate(0.0, 0.35, -1.5);

    // der Rasterizer erhält zuerst die zu malenden
    // Linien der Szene und malt sie dann
    theRasterizer.stageLines();
    theRasterizer.paintScene(); //<>//
}
