class WireFrame {
    // Listen der zu zeichnenden Linien und ihrer
    // Endpunkte (Vertices)
    final ArrayList<Line> lines;
    final ArrayList<Point3D> vertices;

    // wie dieser WireFrame zu transformieren ist
    Transform3D modelTransform;

    // der Konstruktor legt leere Listen an
    WireFrame() {
        lines = new ArrayList<Line>();
        vertices = new ArrayList<Point3D>();
        
        modelTransform = new Transform3D();
    }

    // fügt dem Modell einen Endpunkt (Vertex) hinzu
    void addVertex(final Point3D p) {
        vertices.add(p);
    }

    // fügt dem Modell eine Linie hinzu
    // es werden nur die Nummern der Punkte (Vertices)
    // gespeichert
    void addLine(final int v0, final int v1) {
        lines.add(new Line(v0, v1));
    }

    // fügt dem Modell eine Linie mit Farbe pigment hinzu
    void addLine(final int v0, final int v1, color pigment) {
        lines.add(new Line(v0, v1, pigment));
    }

    // setzt die Transformation dieses Modells
    // auf die Einheitsmatrix zurück
    void resetTrafo() {
        modelTransform = new Transform3D();
    }

    // die folgenden Methoden sind nur ein
    // einfacheres Interface zur Modellmatrix

    // skaliert das Modell in alle Richtungen gleich
    void scale(final float S) {
        modelTransform.scale(S, S, S);
    }

    // skaliert das Modell in in x-, y- und z-Richtung
    // unterschiedlich
    void scale(final float Sx, final float Sy, final float Sz) {
        modelTransform.scale(Sx, Sy, Sz);
    }

    // verschiebt das Modell in x-, y- und z-Richtung
    void translate(final float dX, final float dY, final float dZ) {
        modelTransform.translate(dX, dY, dZ);
    }

    // rotiert das Modell den Winkel angle um die x-Achse
    void rotateX(final float angle) {
        modelTransform.rotateX(angle);
    }

    // rotiert das Modell den Winkel angle um die y-Achse
    void rotateY(final float angle) {
        modelTransform.rotateY(angle);
    }

    // rotiert das Modell den Winkel angle um die z-Achse
    void rotateZ(final float angle) {
        modelTransform.rotateZ(angle);
    }

    void mulTransform(final Transform3D B) {
        modelTransform.mulTransform(B);
    }

    // wendet die Gesamttransformation
    // auf einen Punkt an
    Point3D applyModelTransform(Point3D vertex) {
        return modelTransform.apply(vertex);
    }
}
