Scene theScene;
Camera theCamera;
Rasterizer theRasterizer;

Cube c1;
Cube c2;
Cube c3;
Sphere s1;
theCam tc;

void setup() {
    // öffne ein Zeichenfenster mit 640x640 Pixeln
    size(640, 640);

    theScene = new Scene();

    // alle Modelle werden angelegt und der Szene hinzugefügt

    c1 = new Cube();
    theScene.addWireFrame(c1);

    c2 = new Cube();
    theScene.addWireFrame(c2);

    c3 = new Cube();
    theScene.addWireFrame(c3);

    s1 = new Sphere();
    theScene.addWireFrame(s1);

    // tc zeichnet die Pyramide einer Kamera
    tc = new theCam();
    theScene.addWireFrame(tc);

    // wir haben eine bestimmte Kamera,
    // die wir dem Rasterizer bekannt machen
    theCamera = new Camera();
    theRasterizer = new Rasterizer(theScene, theCamera);
}

float T = 5.0; // Periodendauer in s
float omega = TAU/T; // Winkelgeschwindigkeit n s^{-1}
float alpha;

void draw() {
    // wir füllen das Fenster schwarz
    background(0);

    int t = millis(); // Zeit seit Beginn der Animation in ms
    alpha = omega*t*1.0e-3; // *1.0e-3 Umrechnung ms -> s

    theCamera.setEyeAndLookAt(new Point3D(3.0, 0.0, -1.5),
                              new Point3D(0.0, 0.0, -1.5),
                              new Vec3D(0.0, 1.0, 0.0));

    float r = 2.0;
    float eye_y = -1.0;

    // um die Kamera zeigen zu können, müssen wir die Transformation
    // händisch nachstellen

    Point3D eye = new Point3D(r*sin(alpha), eye_y, -1.5 + r*cos(alpha));
    Point3D lookAt = new Point3D(0.0, 0.0, -1.5);
    Vec3D up = new Vec3D(0.0, 1.0, 0.0);
    
    Vec3D fwd0 = Vec3D_normalize(lookAt.minus(eye));
    Vec3D right0 = Vec3D_normalize(fwd0.cross(up));
    Vec3D up0 = right0.cross(fwd0);

    Transform3D viewTransform = new Transform3D(right0.x, right0.y, right0.z, -eye.dot(right0),
                                                   up0.x,    up0.y,    up0.z, -eye.dot(up0),
                                                 -fwd0.x,  -fwd0.y,  -fwd0.z,  eye.dot(fwd0),
                                                     0.0,      0.0,      0.0,  1.0);

    //viewTransform = new Transform3D(); // würde die Standardkamera zeigen

    // die Objekte werden in jedem Frame neu transformiert

    tc.resetTrafo();
    
    c1.resetTrafo();
    c1.scale(0.25, 0.375, 0.5);
    c1.translate(0.0, -0.75, -1.5);
    c1.mulTransform(viewTransform);

    c2.resetTrafo();
    c2.scale(0.25);
    c2.translate(-0.75, 0.75, -1.5);
    c2.mulTransform(viewTransform);

    c3.resetTrafo();
    c3.scale(0.25);
    c3.translate(0.75, 0.75, -1.5);
    c3.mulTransform(viewTransform);

    s1.resetTrafo();
    s1.scale(0.35);
    s1.translate(0.0, 0.35, -1.5);
    s1.mulTransform(viewTransform);

    // der Rasterizer erhält zuerst die zu malenden
    // Linien der Szene und malt sie dann
    theRasterizer.stageLines();
    theRasterizer.paintScene(); //<>//
}
