class Cube extends WireFrame {
    // der Konstruktor legt einen Würfel zentriert um den Urpsrung
    // und mit Seitenlänge 1 an; die Würfelkanten sind parallel zu
    // den Koordinatenachsen
    Cube() {
        super();

        // Punkte hinzufügen
        addVertex(new Point3D(-0.5, -0.5,  0.5)); // 0
        addVertex(new Point3D( 0.5, -0.5,  0.5)); // 1
        addVertex(new Point3D( 0.5,  0.5,  0.5)); // 2
        addVertex(new Point3D(-0.5,  0.5,  0.5)); // 3
        addVertex(new Point3D(-0.5, -0.5, -0.5)); // 4
        addVertex(new Point3D( 0.5, -0.5, -0.5)); // 5
        addVertex(new Point3D( 0.5,  0.5, -0.5)); // 6
        addVertex(new Point3D(-0.5,  0.5, -0.5)); // 7

        // Punkte für das lokale Koordinatensystem
        addVertex(new Point3D(0.0, 0.0, 0.0)); //  8
        addVertex(new Point3D(1.0, 0.0, 0.0)); //  9
        addVertex(new Point3D(0.0, 1.0, 0.0)); // 10
        addVertex(new Point3D(0.0, 0.0, 1.0)); // 11

        // Linien hinzufügen
        // Vorderseite
        addLine(0, 1);
        addLine(1, 2);
        addLine(2, 3);
        addLine(3, 0);
        // Rückseite
        addLine(4, 5);
        addLine(5, 6);
        addLine(6, 7);
        addLine(7, 4);
        // Linien der Seitenflächen
        addLine(0, 4);
        addLine(1, 5);
        addLine(2, 6);
        addLine(3, 7);

        // lokales Koordinatensystem
        addLine(8,  9, color(255, 0, 0)); // rot = x
        addLine(8, 10, color(100, 255, 0)); // grün = y
        addLine(8, 11, color(0, 0, 255)); // blau = z
    }
}

class Sphere extends WireFrame {
    private final int N = 20;

    // der Konstruktor legt eine Kugel mit Mittelpunkt im Ursprung
    // und Radius 1 an
    Sphere() {
        super();

        // Punkte hinzufügen
        // Südpol
        addVertex(new Point3D(0.0, -1.0, 0.0));
        // alle Punkte zwischen Süd- und Nordpol
        for (int i = 1; i < N/2; ++i) {
        // "geographische" Breite; wir beginnen beim Südpol
            float theta = PI - i*(PI/(N/2)); 
            for (int j = 0; j < N; ++j) {
                // "geographische" Länge
                float phi = j*(TAU/N);
                addVertex(new Point3D(sin(theta)*sin(phi),
                                      cos(theta),
                                      sin(theta)*cos(phi)));
            }
        }
        // Nordpol
        addVertex(new Point3D(0.0, 1.0, 0.0));

        // Linien hinzufügen
        int jp1; // j + 1
        // Dreiecke um den Südpol
        for (int j = 1; j <= N; ++j) {
            if (j < N) {
                jp1 = j + 1;
            }
            else {
                jp1 = 1;
            }
            addLine(0, j);
            addLine(j, jp1);
        }
        // Quadrate um Breiten-/Längenkreise zu zeichnen
        for (int i = 0; i < N/2 - 2; ++i) {
            for (int j = 1; j <= N; ++j) {
                if (j < N) {
                    jp1 = j + 1;
                }
                else {
                    jp1 = 1;
                }
                addLine(j + i*N, j + (i + 1)*N);
                addLine(j + (i + 1)*N, jp1 + (i + 1)*N);
            }
        }
        // Dreiecke um den Nordpol
        for (int j = 1; j <= N; ++j) {
            addLine(vertices.size() - N - 2 + j, vertices.size() - 1);
        }

        final int numVertices = vertices.size();

        // Punkte für das lokale Koordinatensystem
        addVertex(new Point3D(0.0, 0.0, 0.0)); // numVertices 
        addVertex(new Point3D(1.5, 0.0, 0.0)); // numVertices + 1
        addVertex(new Point3D(0.0, 1.5, 0.0)); // numVertices + 2
        addVertex(new Point3D(0.0, 0.0, 1.5)); // numVertices + 3

        // lokales Koordinatensystem
        addLine(numVertices,  numVertices + 1, color(255, 0, 0)); // rot = x
        addLine(numVertices,  numVertices + 2, color(100, 255, 0)); // grün = y
        addLine(numVertices,  numVertices + 3, color(0, 0, 255)); // blau = z
    }
}
