class Transform3D {

    // affine Transformationsmatrix;
    // wir starten mit der Einheitsmatrix
    private float[][] M = {{1.0, 0.0, 0.0, 0.0},
                           {0.0, 1.0, 0.0, 0.0},
                           {0.0, 0.0, 1.0, 0.0},
                           {0.0, 0.0, 0.0, 1.0}};

    // mit dem Standardkonstruktor bleibt es bei
    // der Einheitsmatrix
    Transform3D() {}

    // ersetzt die gespeicherte Matrix m durch B*m
    private void mul(final float[][] B) {
        // weil wir die Elemente von m für die Multiplikation
        // benötigen, müssen wir das Produkt zuerst in c
        // speichern
        float[][] C = new float[4][4]; // Java initialisiert Arrays mit 0

        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                for (int k = 0; k <= 3; ++k) {
                    C[i][j] += B[i][k]*M[k][j];
                }
            }
        }

        // jetzt können wir das Produkt nach M kopieren
        M = C;
    }

    // multipliziert die aktuelle Transformation mit
    // einer Skalierung in x-, y- und z-Richtung
    void scale(final float Sx, final float Sy, final float Sz) {
        final float[][] B = {{ Sx, 0.0, 0.0, 0.0},
                             {0.0,  Sy, 0.0, 0.0},
                             {0.0, 0.0,  Sz, 0.0},
                             {0.0, 0.0, 0.0, 1.0}};
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Translation in x-, y- und z-Richtung
    void translate(final float dX, final float dY, final float dZ) { 
        final float[][] B = {{1.0, 0.0, 0.0,  dX},
                             {0.0, 1.0, 0.0,  dY},
                             {0.0, 0.0, 1.0,  dZ},
                             {0.0, 0.0, 0.0, 1.0}};
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Rotation um die x-Achse
    void rotateX(final float angle) {
        final float[][] B = {{1.0,        0.0,         0.0, 0.0},
                             {0.0, cos(angle), -sin(angle), 0.0},
                             {0.0, sin(angle),  cos(angle), 0.0},
                             {0.0,        0.0,         0.0, 1.0}};
        
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Rotation um die y-Achse
    void rotateY(final float angle) {
        final float[][] B = {{ cos(angle), 0.0, sin(angle), 0.0},
                             {        0.0, 1.0,        0.0, 0.0},
                             {-sin(angle), 0.0, cos(angle), 0.0},
                             {        0.0, 0.0,        0.0, 1.0}};
        
        mul(B);
    }

    // multipliziert die aktuelle Transformation mit
    // einer Rotation um die z-Achse
    void rotateZ(final float angle) {
        final float[][] B = {{cos(angle), -sin(angle), 0.0, 0.0},
                             {sin(angle),  cos(angle), 0.0, 0.0},
                             {       0.0,         0.0, 1.0, 0.0},
                             {       0.0,         0.0, 0.0, 1.0}};
        
        mul(B);
    }

    // wendet die aktuelle Transformation auf
    // einen Punkt an;
    // weil die w-Koordinate der Punkte vorerst immer
    // 1 ist, können wir sie ignorieren 
    Point3D apply(final Point3D p) {
        return new Point3D(M[0][0]*p.x + M[0][1]*p.y + M[0][2]*p.z + M[0][3],
                           M[1][0]*p.x + M[1][1]*p.y + M[1][2]*p.z + M[1][3],
                           M[2][0]*p.x + M[2][1]*p.y + M[2][2]*p.z + M[2][3]);
    }
}
