Scene theScene;
Rasterizer theRasterizer;

Cube c1;
Cube c2;
Cube c3;
Sphere s1;

void setup() {
    // öffne ein Zeichenfenster mit 640x640 Pixeln
    size(640, 640);

    theScene = new Scene();

    // alle Modelle werden angelegt und der Szene hinzugefügt

    c1 = new Cube();
    theScene.addWireFrame(c1);

    c2 = new Cube();
    theScene.addWireFrame(c2);

    c3 = new Cube();
    theScene.addWireFrame(c3);

    s1 = new Sphere();
    theScene.addWireFrame(s1);

    theRasterizer = new Rasterizer(theScene);
}

float T = 5.0; // Periodendauer in s
float omega = TAU/T; // Winkelgeschwindigkeit in s^{-1}
float alpha;

void draw() {
    // wir füllen das Fenster schwarz
    background(0);

    int t = millis(); // Zeit seit Beginn der Animation in ms
    alpha = omega*t*1.0e-3; // *1.0e-3 Umrechnung ms -> s

    // die Objekte werden in jedem Frame neu transformiert

    c1.resetTrafo();
    c1.scale(0.25, 0.375, 0.5);
    c1.rotateX(alpha);
    c1.rotateY(2.0*alpha);
    c1.translate(0.75*sin(alpha), -0.75, -1.5);

    c2.resetTrafo();
    c2.scale(0.25);
    c2.rotateX(2.0*alpha);
    c2.translate(-0.75, 0.75, -1.5 - sin(alpha));

    c3.resetTrafo();
    c3.scale(0.25);
    c3.rotateZ(2.0*alpha);
    c3.translate(0.75, 0.75, -1.5);

    s1.resetTrafo();
    s1.scale(0.35);
    s1.rotateY(alpha);
    s1.translate(0.0, 0.25, -1.5);

    // der Rasterizer erhält zuerst die zu malenden
    // Linien der Szene und malt sie dann
    theRasterizer.stageLines();
    theRasterizer.paintScene(); //<>//
}
