class WireFrame {
    // Listen der zu zeichnenden Linien und ihrer
    // Endpunkte (Vertices)
    final ArrayList<Line> lines;
    final ArrayList<Point3D> vertices;

    // der Konstruktor legt leere Listen an
    WireFrame() {
        lines = new ArrayList<Line>();
        vertices = new ArrayList<Point3D>();
    }

    // fügt dem Modell einen Endpunkt (Vertex) hinzu
    void addVertex(final Point3D p) {
        vertices.add(p);
    }

    // fügt dem Modell eine Linie hinzu
    // es werden nur die Nummern der Punkte (Vertices)
    // gespeichert
    void addLine(final int v0, final int v1) {
        lines.add(new Line(v0, v1));
    }
}
