Scene theScene;
Rasterizer theRasterizer;

Cube c1;
Cube c2;
Cube c3;
Sphere s1;

void setup() {
    // öffne ein Zeichenfenster mit 640x640 Pixeln
    size(640, 640);

    theScene = new Scene();

    // alle Modelle werden angelegt und der Szene hinzugefügt

    c1 = new Cube(new Point3D(0.0, -0.75, -1.5), 0.5);
    theScene.addWireFrame(c1);

    c2 = new Cube(new Point3D(-0.75, 0.75, -1.0), 0.25);
    theScene.addWireFrame(c2);

    c3 = new Cube(new Point3D(0.75, 0.75, -1.5), 0.25);
    theScene.addWireFrame(c3);

    s1 = new Sphere(new Point3D(0.0, 0.25, -0.75), 0.5);
    theScene.addWireFrame(s1);

    theRasterizer = new Rasterizer(theScene);
    //theRasterizer.doClipping = false;
}

void draw() {
    // wir füllen das Fenster schwarz
    background(0);

    // und setzen die Malfarbe auf grün
    stroke(0, 255, 0);

    // der Rasterizer erhält zuerst die zu malenden
    // Linien der Szene und malt sie dann
    theRasterizer.stageLines();
    theRasterizer.paintScene();

    // speichert das Bild ab
    save("RS02_WF_clipping_on.png");

    // es reicht, das Bild einmal zu malen
    noLoop();
} //<>//
