class Cube extends WireFrame {
    // der Konstruktor legt einen Würfel mit Mittelpunkt center
    // und Seitenlänge len an; die Würfelkanten sind parallel zu den 
    // Koordinatenachsen
    Cube(final Point3D center, final float len) {
        super();

        // Punkte hinzufügen
        addVertex(new Point3D(center.x - len/2, center.y - len/2, center.z + len/2)); // 0
        addVertex(new Point3D(center.x + len/2, center.y - len/2, center.z + len/2)); // 1
        addVertex(new Point3D(center.x + len/2, center.y + len/2, center.z + len/2)); // 2
        addVertex(new Point3D(center.x - len/2, center.y + len/2, center.z + len/2)); // 3
        addVertex(new Point3D(center.x - len/2, center.y - len/2, center.z - len/2)); // 4
        addVertex(new Point3D(center.x + len/2, center.y - len/2, center.z - len/2)); // 5
        addVertex(new Point3D(center.x + len/2, center.y + len/2, center.z - len/2)); // 6
        addVertex(new Point3D(center.x - len/2, center.y + len/2, center.z - len/2)); // 7

        // Linien hinzufügen
        // Vorderseite
        addLine(0, 1);
        addLine(1, 2);
        addLine(2, 3);
        addLine(3, 0);
        // Rückseite
        addLine(4, 5);
        addLine(5, 6);
        addLine(6, 7);
        addLine(7, 4);
        // Linien der Seitenflächen
        addLine(0, 4);
        addLine(1, 5);
        addLine(2, 6);
        addLine(3, 7);
    }
}

class Sphere extends WireFrame {
    private final int N = 16;

    // der Konstruktor legt eine Kugel mit Mittelpunkt center
    // und Radius radius an
    Sphere(final Point3D center, final float radius) {
        super();

        // Punkte hinzufügen
        // Südpol
        addVertex(new Point3D(center.x, center.y - radius, center.z));
        // alle Punkte zwischen Süd- und Nordpol
        for (int i = 1; i < N/2; ++i) {
        // "geographische" Breite; wir beginnen beim Südpol
            float theta = PI - i*(PI/(N/2)); 
            for (int j = 0; j < N; ++j) {
                // "geographische" Länge
                float phi = j*(TAU/N);
                addVertex(new Point3D(center.x + radius*sin(theta)*sin(phi),
                                      center.y + radius*cos(theta),
                                      center.z + radius*sin(theta)*cos(phi)));
            }
        }
        // Nordpol
        addVertex(new Point3D(center.x, center.y + radius, center.z));

        // Linien hinzufügen
        int jp1; // j + 1
        // Dreiecke um den Südpol
        for (int j = 1; j <= N; ++j) {
            if (j < N) {
                jp1 = j + 1;
            }
            else {
                jp1 = 1;
            }
            addLine(0, j);
            addLine(j, jp1);
        }
        // Quadrate um Breiten-/Längenkreise zu zeichnen
        for (int i = 0; i < N/2 - 2; ++i) {
            for (int j = 1; j <= N; ++j) {
                if (j < N) {
                    jp1 = j + 1;
                }
                else {
                    jp1 = 1;
                }
                addLine(j + i*N, j + (i + 1)*N);
                addLine(j + (i + 1)*N, jp1 + (i + 1)*N);
            }
        }
        // Dreiecke um den Nordpol
        for (int j = 1; j <= N; ++j) {
            addLine(vertices.size() - N - 2 + j, vertices.size() - 1);
        }
    }
}
