class Rasterizer { //<>//
    // private Referenz auf die Szene
    private final Scene scene;

    // private Listen der zu zeichnenden Linien und ihrer
    // Endpunkte, der Vertices
    private final ArrayList<Line> lines;
    private final ArrayList<Point3D> vertices;

    // der Konstruktor speichert eine private Referenz auf die Szene
    // und legt die Linien- und Endpunktlisten an
    public Rasterizer(Scene scene) {
        this.scene = scene;

        lines = new ArrayList<Line>();
        vertices = new ArrayList<Point3D>();
    }

    // füge die Linien aller Wireframe-Modelle in der Szene
    // dem Rasterizer hinzu
    public void stageLines() {

        // wir bearbeiten alle Wireframe-Modelle in der Szene
        for (WireFrame wf : scene.wireFrames) {

            // in den Wireframe-Modellen starten die Punktnummern
            // immer bei 0; hier werden sie jedoch hintereinander
            // eingefügt; wir müssen die bisherige Anzahl an
            // Punkten also speichern
            final int numOfVertices = vertices.size();

            // jetzt werden die neuen Punkte eingefügt
            for (Point3D v : wf.vertices) {
                vertices.add(v);
            }

            // hier werden die neuen Linien eingefügt und die
            // Punktnummern entsprechend angepasst
            for (Line l : wf.lines) {
                lines.add(new Line(l.v0 + numOfVertices, l.v1 + numOfVertices));
            }
        }
    }

    // male die Szene
    public void paintScene() {

        // male alle zu rasternden Linien
        for (Line l : lines) {

            // lade die Endpunkte der aktuellen Linie
            final Point3D v0 = vertices.get(l.v0);
            final Point3D v1 = vertices.get(l.v1);

            // und berechne ihre screen coordinates
            final int x0 = (int)((1.0 - v0.x/v0.z)*width/2.0);
            final int y0 = (int)((1.0 + v0.y/v0.z)*height/2.0);
            final int x1 = (int)((1.0 - v1.x/v1.z)*width/2.0);
            final int y1 = (int)((1.0 + v1.y/v1.z)*height/2.0);

            // der line-Befehl von Processing kümmert sich
            // um das Clipping links/rechts und oben/unten
            line(x0, y0, x1, y1);
        }
    }
}
