class Rasterizer { //<>//
    // private Referenz auf die Szene
    private final Scene scene;

    // der Konstruktor speichert eine private Referenz auf die Szene
    Rasterizer(Scene scene) {
        this.scene = scene;
    }

    // male die Szene
    void paintScene() {
        
        // male alle Punkte der Szene
        for (Point3D p : scene.points) {

            // aber nur, wenn sie vor der Kamera liegen
            if (p.z <= -1.0) {

                // berechne die screen coordinates
                // width/height sind Breite/Höhe des Zeichenfensters in Pixel
                final int xS = (int)((1.0 - p.x/p.z)*width/2.0);
                final int yS = (int)((1.0 + p.y/p.z)*height/2.0);

                // um die Punkte besser sehen zu können, zeichnen wir sie
                // als kleine Kreise
                // circle kümmert sich auch darum, ob die Punkte außerhalb
                // unseres Bildschirms sind
                circle(xS, yS, 4);
            }
        }
    }
}
