Scene theScene; //<>//
Rasterizer theRasterizer;

void setup() {
    // öffne ein Zeichenfenster mit 640x640 Pixeln
    size(640, 640);

    theScene = new Scene();

    addPointsToScene();

    theRasterizer = new Rasterizer(theScene);
}

void draw() {
    // wir füllen das Fenster schwarz
    background(0);

    // und setzen die Malfarbe auf grün
    fill(0, 255, 0);
    stroke(0, 255, 0);

    // der Rasterizer malt jetzt die Szene
    theRasterizer.paintScene();

    // speichert das Bild ab
    save("sphere.png");

    // es reicht, das Bild einmal zu malen
    noLoop();
}

void addPointsToScene() {
    // Punkte auf einer Kugel
    final int N = 16;
    final float radius = 1.0;

    // Koordinaten des Mittelpunkts
    final float cx =  0.0;
    final float cy =  0.0;
    final float cz = -2.5;
    
    // Südpol
    theScene.addPoint(new Point3D(cx, cy - radius, cz));
    // alle Punkte zwischen Süd- und Nordpol
    for (int i = 1; i < N/2; ++i) {
        // "geographische" Breite; wir beginnen beim Südpol
        float theta = PI - i*(PI/(N/2));
        for (int j = 0; j < N; ++j) {
            // "geographische" Länge
            float phi = j*(TAU/N);
            theScene.addPoint(new Point3D(cx + radius*sin(theta)*sin(phi),
                                          cy + radius*cos(theta),
                                          cz + radius*sin(theta)*cos(phi)));
        }
    }
    // Nordpol
    theScene.addPoint(new Point3D(cx, cy + radius, cz));
}
